if not exists(select 1 from sys.syscolumns where tname = 'RegServices' and cname='VersionModule') then
   alter table RegServices add VersionModule varchar(25) not NULL default '';
end if;

if exists(select 1 from sys.sysprocedure where proc_name='RegService') then
  drop procedure RegService;
  commit;
end if;

create FUNCTION RegService(in aInterfaceId integer,
                           in aHost varchar(128),
                           in aIP varchar(32),
                           in aLocalPort integer,
                           in aStatus varchar(64),
                           in aDescription varchar(254) default '',
                           in aSubInterfaceId integer default 0,
                           in aLastUpdate datetime default NULL,
                           in aDbInterval integer default 0,
                           in aVersionModule varchar(25) default '')
returns integer
begin
  ------------------------------------
  -- RegService
  ------------------------------------
  -- 13.09.16 17:14 / TO  / 6.16.09 Created
  -- 06.07.17 16:18 / TO  / 6.17.07 add Host for check
  -- 29.09.21 15:47 / TO  / 6.21.09 add aLastUpdate and aDbInterval
  -- 18.04.25 11:34 / TO  / 7.25.04 select first 
  -- 14.08.25 17:57 / TO  / 7.25.08 замена при проверке Host на IP
  -- 19.11.25 19:30 / TO  / 7.25.11 добавлена версия модуля
  --
  -- params:
  --        aSubInterfaceId - если в системе используется одна и то же служба, но для разных юр. лиц (например WuBook в Станции)
  -- result:
  --        0 - 
  --       NN - 
  ------------------------------------
  declare has integer;
  declare tId integer;
  --
  set has = 0;
  set tId = 0;  
  --
  select first ID into has from RegServices where INTERFACEID = aInterfaceId and SubInterfaceId = aSubInterfaceId and IP = aIP order by id desc;
  --
  if has = 0 then
     insert into RegServices (InterfaceId,Host,IP,LocalPort,Status,SubInterfaceId,Description,LastUpdate,DbInterval,VersionModule) 
               values (aInterfaceId,aHost,aIP,aLocalPort,aStatus,aSubInterfaceId,aDescription,aLastUpdate,aDbInterval,aVersionModule); 
     set tId = @@identity;
  else
     set tId = has;      
     update RegServices set Host = aHost, IP = aIP, LocalPort = aLocalPort, Status = aStatus where ID = tId;
     --
     if aLastUpdate is not NULL then
        update RegServices set LastUpdate = aLastUpdate where ID = tId;
     end if;
     --
     if aDbInterval != 0 then
        update RegServices set DbInterval = aDbInterval where ID = tId;
     end if;
     --
     if aVersionModule != '' then
        update RegServices set VersionModule = aVersionModule where ID = tId;
     end if;
     --
  end if;
  --
return tId;
end;
commit;

if not exists(select 1 from sys.syscolumns where tname='sparte' AND cname='inInternetPay') then
   alter table sparte add inInternetPay integer not NULL default 0;
end if;
commit;